// UpdateFAThread.java
// Both 14 feb

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import Globals;

public class UpdateFAThread extends Thread {
  public Letter2 L;
  private int startX, startY, endX, endY, x ,y;
  Graphics g;
  ShowMobileIPCanvas canvas;
  Agent receiver;
  String sendText;

  public void start(Agent receiver,
		    ShowMobileIPCanvas father, String sendText) {
    this.canvas = father; 
    this.startX = Globals.FA[0].x; this.startY = Globals.FA[0].y; 
    this.endX = receiver.x; this.endY = receiver.y; 
    this.x = startX; this.y = this.startY;
    this.receiver =receiver;
    this.sendText =sendText;
    L = new Letter2(canvas);
    g = canvas.getGraphics();
    super.start(); // run() MUST be started from Thread.start()
  }
  
  public void run() {
    Globals.actionAllowed = false; // MH interaction disabled
    L.drawLetter(g, startX, startY); 
    canvas.frame.setCont();
    // Define letter informationText
    L.info =  "Contains a message saying that MH now is registered at " 
               + Globals.MH.connected.name + ".\n" 
               + "Future data should be sent directly to "
               + Globals.MH.connected.name+ ".";
    canvas.frame.textArea1.appendHiLit(sendText);
    run1(endX, endY);
    receiver.believeMH = Globals.MH.connected;
    int i = 0;
    while (receiver != Globals.FA[i])
      i++;
    if (Globals.dialogExist[i])
      Globals.Dialogs[i].reDraw2();
    Globals.MH.needUpdate[i] = true;
    pause(Globals.pauseTime);
    L.eraseLetter(g);
    canvas.frame.setDisabled(); // Disables buttons

    Globals.actionAllowed = true; // MH interaction allowed
    stop(); // Make the Thread disappear
  } // end run()

   // Animation of Letter
  private void run1(int toX, int toY) {
    int biggest = Math.max(Math.abs(toY - y), Math.abs(toX - x));
    float dx = (float) (toX - x) / biggest;
    float dy = (float) (toY - y) / biggest;
    float xtemp = (float) x;
    float ytemp = (float) y; 
    float minToY = toY - Math.abs(dy)/2, maxToY = toY + Math.abs(dy)/2;
    float minToX = toX - Math.abs(dx)/2, maxToX = toX + Math.abs(dx)/2;
  
  
    // while ((x != toX) && (y != toY)) { 
    while (!(((ytemp < maxToY) && (ytemp > minToY)) && 
	     ((xtemp < maxToX) && (xtemp > minToX)))) {
      if (Globals.contAllowed) { // Check whether user pressed Stop 
     	xtemp  = xtemp+dx;
	ytemp  = ytemp+dy;
	g.setColor(Color.lightGray);
	g.fillRect(x-1, y-1, 22, 14);
	x = (int) xtemp;
	y = (int) ytemp;
	canvas.paint(g); 
	L.drawLetter(g, x, y); 
	try {  
	  sleep(Globals.sleepTime);
	} catch (InterruptedException e) {break;}
      }
      else { // Wait for user to press continue
	canvas.frame.setStop(); // Activate Stopbutton
	this.suspend();
      }
    } // end while   
  } 
    
  public void pause(int time) {
    try {  
      Thread.sleep(time);
    } catch (InterruptedException e) {}
  }
}
	
